/*****************************************
*Dateiname: Application.java
*Autor: Utz Roedig
*letzte Aenderung: Gunter Weiss 07/97
*Inhalt: Klasse zum Anlegen eines Applicationfensters
*****************************************/

import java.awt.*;
import java.lang.*;

/*****************************************
*Klasse: application
*Beschreibung: Legt ein Fenster fr die Applikation an
*****************************************/
class Application extends CreateWindow implements Runnable{

     Thread t;             // Thread
     TcpStarter outerparent;
     aboutbox about = new aboutbox(); // Infofenster erzeugen
     Host host;            // Host auf dem die Application sitzt
     int suc;              // enthlt Fehlermeldung des TCP
     int connectionid=-1;  // Status der Verbindung
     short destport=23;
     short locport=23;
     int todo=0;           // Was gibts zu tun?


     int receivesize =20;  // Sende und Empfangsgren
     int sendsize = 20;

     byte receivevalue[];  // fr den Empfang
     public StringBuffer rec=new StringBuffer("");

     // Telnet
     Telnet telnet = new Telnet(this);
     // Standard Text fr Telnet
     String sentext="Das Reh springt hoch das Reh springt weit, warum auch nicht es hat ja Zeit";
     String rectext=">";                    // Empfangsstring
     int number=0;
     byte[] sendvalue = new byte[sendsize]; // Sende String
     byte push=0;                           // Push ja nein

     // ftp
     Ftp ftp=new Ftp(this);
     int ftplength=2000;    // Gre der Standarddatei
     int ftpreceived=0;     // Empfange bytes
     int ftpcounter=0;      // gesendete bytes




     //***** Layout
        Panel applicationpanel= new Panel();
        Panel checkpanel      = new Panel();
        Panel buttonpanel     = new Panel();
        Panel portpanel       = new Panel();
        Panel cppanel         = new Panel();
        Panel chspanel        = new Panel();
        Panel pictpanel       = new Panel();
        Panel pcpanel         = new Panel();
        Panel dapanel         = new Panel();
        public Image apppict;     // Das aktuelle Bildchen
        public Image telnetpict;  // TELNET-Picture
        public Image ftppict;     // FTP-Picture
        Pict p1=new Pict(apppict,50,60,40,40);

        CheckboxGroup group1;
        Checkbox httpcheck;
        Checkbox ftpcheck;
        Checkbox telnetcheck;
        TextField edit1;
        TextField edit2;
        Button serverbutton;
        Button clientbutton;
        Button dismissbutton;
        Button abortbutton;

        Label idlabel;
        Label statuslabel;
        List list1;


        Menu menu1;
        Menu menu2;
        Menu menu4;
        CheckboxMenuItem bs1;
        CheckboxMenuItem bs10;
        CheckboxMenuItem bs20;
        CheckboxMenuItem bs100;
        CheckboxMenuItem kbs;
        Menu menu3;
        CheckboxMenuItem b1;
        CheckboxMenuItem b10;
        CheckboxMenuItem b20;
        CheckboxMenuItem b100;
        CheckboxMenuItem kb1;
    //***** Layout

/*****************************************
* Methode: Application
* Beschreibung: initialisiert die Application
* Parameter: hauptfenster, Host, titel
* Rckgabewert : keiner
*****************************************/
void Application( TcpStarter home, Host host, String label) {
         this .outerparent = home;
         this .host = host;


         //Layout
         setTitle(label);
         setBackground(Color.lightGray);
         setLayout(new GridLayout(4,1,5,5));
         addNotify();

         // Application
         applicationpanel. setLayout(new GridLayout(1,1,5,5));
         applicationpanel. add(telnet);
         add(applicationpanel);

         // Picture
         telnetpict = home.grabimages.giveImage("picts/telnet.jpg");
         ftppict = home.grabimages.giveImage("picts/server2.jpg");
         apppict = telnetpict;
         pictpanel. setLayout(new GridLayout(1,1,5,5));
         pictpanel. add(p1);
         p1. setPict(apppict);

         // Checker
         checkpanel. setLayout(new GridLayout(3,1,5,5));
         group1= new CheckboxGroup();
         httpcheck = new Checkbox("HTTP",group1, false);
         httpcheck. disable();
         ftpcheck = new Checkbox("FTP",group1, false);
         telnetcheck = new Checkbox("TELNET",group1, true);
         checkpanel. add(httpcheck);
         checkpanel. add(ftpcheck);
         checkpanel. add(telnetcheck);

         //Picture + Checker
         pcpanel. setLayout(new GridLayout(1,2,5,5));
         pcpanel. add(pictpanel);
         pcpanel. add(checkpanel);

         // Ports
         portpanel. setLayout(new GridLayout(2,2,5,5));
         edit1 = new TextField(5);
         edit2 = new TextField(5);
         Label lp = new Label("Local   PORT:");
         Label dp = new Label("Dest.   PORT:");
         lp. setFont(new Font("Arial",Font.BOLD,12));
         dp. setFont(new Font("Arial",Font.BOLD,12));
         portpanel. add(lp);
         portpanel. add(dp);
         portpanel. add(edit1);
         portpanel. add(edit2);
         edit1. setText(String.valueOf(locport));
         edit2. setText(String.valueOf(destport));

         // Checker + Ports + Picture
         cppanel. setLayout(new GridLayout(1,2,5,5));
         cppanel. add(pcpanel);
         cppanel. add(portpanel);
         add(cppanel);

         // Command History + Status
         chspanel. setLayout(new GridLayout(2,3,5,5));
         idlabel = new Label("none");
         statuslabel = new Label("not connected");
         list1 = new List();
         chspanel. add(new Label("Connection ID:"));
         chspanel. add(new Label("State :"));
         Label ch = new Label("TCP command-history:");
         ch. setFont(new Font("Arial",Font.BOLD,10));
         chspanel. add(ch);
         chspanel. add(idlabel);
         chspanel. add(statuslabel);
         chspanel. add(list1);
         add(chspanel);

         // Buttons
         serverbutton = new Button("S E R V E R");
         clientbutton = new Button("C L I E N T");
         dismissbutton= new Button("Dismiss");
         abortbutton  = new Button("ABORT");
         buttonpanel. setLayout(new GridLayout(1,3,5,5));
         buttonpanel. add(serverbutton);
         dapanel. setLayout(new GridLayout(2,1,5,5));
         dapanel. add(abortbutton);
         dapanel. add(dismissbutton);
         buttonpanel. add(dapanel);
         buttonpanel. add(clientbutton);
         add(buttonpanel);


         // Fenstergre festlegen
         resize(450,370);

         //{{INIT_MENUS
         MenuBar mb = new MenuBar();
         menu1 = new Menu("Window");
         menu1. add(new MenuItem("Exit!"));
         mb. add(menu1);
         menu2 = new Menu("Settings");
         menu4 = new Menu("Send size");
         menu4. add(bs1 = new CheckboxMenuItem("5 byte"));
         menu4. add(bs10 = new CheckboxMenuItem("10 byte"));
         menu4. add(bs20 = new CheckboxMenuItem("20 byte"));
         ((CheckboxMenuItem) bs20).setState(true);
         menu4. add(bs100 = new CheckboxMenuItem("100 byte"));
         menu4. add(kbs = new CheckboxMenuItem("1 kbyte"));
         menu2. add(menu4);
         menu3 = new Menu("Receive size");
         menu3. add(b1 = new CheckboxMenuItem("5 byte"));
         menu3. add(b10 = new CheckboxMenuItem("10 byte"));
         menu3. add(b20 = new CheckboxMenuItem("20 byte"));
         ((CheckboxMenuItem) b20).setState(true);
         menu3. add(b100 = new CheckboxMenuItem("100 byte"));
         menu3. add(kb1 = new CheckboxMenuItem("1 kbyte"));
         menu2. add(menu3);
         mb. add(menu2);
         setMenuBar(mb);
         //}}


         setControl(1,1,1,1,1,1,0);
         // Thread
         this.start();
}
/*****************************************
* Methode: setPict
* Beschreibung: Setzt das Bild welches den
* Application Typ signalisiert
* Parameter: das Bild
* Rckgabewert : keiner
*****************************************/
synchronized void setPict(Image apppict){
    this.apppict=apppict;
    p1.setPict(apppict);
}
/*****************************************
* Methode: setControl
* Beschreibung: Aktiviert oder Deaktiviert die Eingaben
* Parameter: integer Werte
* Rckgabewert : keiner
*****************************************/
void setControl(int server,int client,
              int localportinput,int destportinput,
              int ftpchecker,int telnetchecker,int abort){
     if (server==1)         serverbutton.enable();
     if (server==0)         serverbutton.disable();
     if (client==1)         clientbutton.enable();
     if (client==0)         clientbutton.disable();
     if (localportinput==1) edit1.enable();
     if (localportinput==0) edit1.disable();
     if (destportinput==1)  edit2.enable();
     if (destportinput==0)  edit2.disable();
     if (telnetchecker==1)  telnetcheck.enable();
     if (telnetchecker==0)  telnetcheck.disable();
     if (ftpchecker==1)     ftpcheck.enable();
     if (ftpchecker==0)     ftpcheck.disable();
     if (abort==1)          abortbutton.enable();
     if (abort==0)          abortbutton.disable();
}
/*****************************************
* Methode: start
* Beschreibung: zum Starten des Threads
* Parameter:  keine
* Rckgabewert : keiner
*****************************************/
public void start(){
        if (t==null){
            t=new Thread(this);
            t.start();
        }
}
/*****************************************
* Methode: run
* Beschreibung: Run Methode
* Parameter:  keine
* Rckgabewert : keiner
*****************************************/
public void run(){
        while (true){
        try{t.sleep(500);} catch( InterruptedException e){}
        if (connectionid>=0){  // prfen ob Port geffnet
          switch (host.getStatus(connectionid).TcpStatus){         // auszufhrende Teile fr die verschiedenen Zustnde
            case 0: //closed
	        setControl(2,2,2,2,2,2,1); // Abort ist mglich!!
                todo=0;                    // nichts ausfhren
                connectionid=-1;
                host.setPict(false,connectionid);
                break;
            case 1: //passive open
                setControl(1,0,0,0,0,0,1);
                statuslabel.setText("Listening...");
                break;
            case 2: //active open
                setControl(0,1,0,0,0,0,1);
                idlabel.setText(String.valueOf(connectionid));
                statuslabel.setText("Connecting...");
                break;
            case 3: // SYN-RCVD
                break;
            case 4: //established
            case 5: // CLOSE_WAIT
                destport=host.getStatus(connectionid).Dpnumb;
                edit2. setText(String.valueOf(destport));
                idlabel. setText(String.valueOf(connectionid));
                setControl(2,2,0,0,0,0,1);
                statuslabel. setText("Connected!!");
                telnet. setControl(1,1,1);
                  if (telnetcheck.getState()) {
                     if (ReceiveTelnet()) list1.addItem("Receive");}
                  if (ftpcheck.getState()) {
                     if (ReceiveFtp()) list1.addItem("Receive");}
                ftp. liget.setData(ftpreceived,ftplength);
                if (ftpcounter==0) ftp.setControl(false,true);
                else ftp.setControl(false,false);
                break;
            case 7: // Fin_Wait_1
            case 8: // Fin_Wait_2
                destport=host.getStatus(connectionid).Dpnumb;
                edit2. setText(String.valueOf(destport));
                idlabel. setText(String.valueOf(connectionid));
                setControl(2,2,0,0,0,0,1);
                statuslabel. setText("Connected!!");
                telnet. setControl(0,0,0);
                  if (telnetcheck.getState()) {
                     if (ReceiveTelnet()) list1.addItem("Receive");}
                  if (ftpcheck.getState()) {
                     if (ReceiveFtp()) list1.addItem("Receive");}
                ftp. liget.setData(ftpreceived,ftplength);
                ftp. setControl(false,false);
                break;
            case 6: // LAST_ACK
                break;
            case 9: // Closing
                break;
            case 10: // Time_Wait
                break;
            default:
                break;
          }
        }
        else{ // wenn kein Port geffnet
            setControl(1,1,1,1,1,1,0);
            serverbutton. setLabel("S E R V E R");
            clientbutton. setLabel("C L I E N T");
            idlabel. setText("none");
            statuslabel. setText("not connected");
            telnet. setControl(0,0,0);
            ftp. setControl(false,false);
            ftplength=2000;
            ftpreceived=0;
            ftpcounter=0;
            ftp. lisend.setData(ftpcounter,ftplength);
            ftp. liget.setData(ftpreceived,ftplength);
        }
        // todo
        switch (todo){
            case 0: // do nothing
            break;
            case 1: // server open
                 serverbutton. setLabel("C L O S E");
                 clientbutton. setLabel("*");
                 statuslabel. setText("Opening...");
                 setControl(0,0,0,0,0,0,0);
                 connectionid=host.t1.Open(locport,destport,0);
                 list1. addItem("OPEN (passive)");
                 if (connectionid>=0) {
                       serverbutton.setLabel("C L O S E");
                       host. setPict(true,connectionid);
                       setControl(1,0,0,0,0,0,1);
                       idlabel. setText(String.valueOf(connectionid));}
                 else {
                      connectionid=-1;             // Port konnte nicht geffnet werden
                      statuslabel. setText("Error opening");
                      setControl(1,1,1,1,1,1,0);}
                 todo=0;
                 break;
            case 2: // server close

                 suc=host.t1.Close(connectionid);
                 list1. addItem("CLOSE");
                 if (suc>=0){// wenn Schlieen erfolgreich
                    host. setPict(false,connectionid);
                    statuslabel. setText("Closing...");
                    setControl(0,0,2,2,2,2,2);
                 }
                 else {  // wenn nicht erfolgreich
                 statuslabel. setText("Error closing"); // ausgabe Fehlermeldung
                 }
                 todo=0;
                 break;
            case 3: // client open
                 statuslabel. setText("Connecting...");
                 serverbutton. setLabel("*");
                 clientbutton. setLabel("C L O S E");
                 setControl(0,0,0,0,0,0,0);
                 connectionid=host.t1.Open(locport,destport,1);
                 list1. addItem("OPEN (active)");
                 if (connectionid>=0) {
                       clientbutton. setLabel("C L O S E");
                       host. setPict(false,connectionid);
                       setControl(0,1,0,0,0,0,1);
                       idlabel. setText(String.valueOf(connectionid));
                 }
                 else {
                 connectionid=-1;
                 statuslabel. setText("Error opening");
                 setControl(1,1,1,1,1,1,0);
                 }
                 todo=0;
                 break;
            case 4: // Client close
                 suc=host.t1.Close(connectionid);
                 list1. addItem("CLOSE");
                 if (suc>=0){
                    statuslabel. setText("Closing...");
                    host. setPict(false,connectionid);
                    setControl(0,0,2,2,2,2,2);}
                 else {statuslabel.setText("Error closing");}
                 todo=0;
                 break;
            case 10: // Telnet send
                 telnet.setControl(0,2,2);
                 // Prfen ob Push oder nicht
                 if (telnet.check2.getState()) todo=TelnetSend(1); else todo=TelnetSend(0);
                 telnet. setControl(1,2,2);
                 list1. addItem("SEND");
                 break;
            case 11: // Ftp send standard file
                 todo=FtpSend();
                 // Button zum erneuten Senden freigeben wenn Datei gesendet
                 if (todo==0) ftp.button2.enable();
                 // Balken nachzeichnen
                 ftp. lisend.setData(ftpcounter,ftplength);
                 list1. addItem("SEND");
                 break;
            case 20: //Abort
                 todo=0;
                 suc=host.t1.Abort(connectionid);
                 if (suc>=0){host.setPict(false,connectionid);}
                 else {statuslabel.setText("Abort not possible");}
                 break;
            default: // do nothing
                 break;
        }
  }
}
/*****************************************
* Methode      : TelnetSend
* Beschreibung : Bereitet die zu sendenden Daten(Text) auf und bergibt sie der Methode Send in TcpProtocol
* Parameter    : int push zeigt dem TCP an, ob Daten sofort geschickt werden sollen 
* Rckgabewert : int todo 0 - Aufhren mit Senden, 10 - Weitersenden
*****************************************/
int TelnetSend(int push){
    sendvalue = new byte[sendsize];          // zu sendende bytes
    number=sentext.length();                 // lnge des Textes ermitteln
    if (number>sendsize) {number=sendsize;}  // maximal
    sentext. getBytes(0,number,sendvalue,0); // text in byte
    suc=host.t1.Send(connectionid,sendvalue,(byte) push,(byte)0);
    if (suc<0) {
       statuslabel. setText("Error sending");
       telnet. check1.setState(false);   //Autosend Ausschalten
    }
    else {
       sentext=sentext.substring(number);//Gesendetes lschen
       telnet. edit1.setText(sentext);
    }
    if (sentext.length()<5) sentext="Das Reh springt hoch das Reh springt weit, warum auch nicht es hat ja Zeit";
    if (!telnet.check1.getState()) return 0; 
    else return 10; //AUTOSEND
}
/*****************************************
* Methode      : FtpSend
* Beschreibung : Kontrolle ob Daten empfangen werden
* Parameter    : keiner
* Rckgabewert : Boolean true wenn Daten empfangen werden
*****************************************/
int FtpSend(){
    // Festlegen der noch zu sendenden Bytes
    if ((ftpcounter+sendsize)>ftplength) sendvalue= new byte[ftplength-ftpcounter];
    else sendvalue = new byte[sendsize];
    // Feststellen ob ende der Datei, Senden entsprechend mit oder ohne Push
    if ((ftpcounter+sendsize)>=ftplength) {
        suc=host.t1.Send(connectionid,sendvalue,(byte)1,(byte)0);}
    else {suc=host.t1.Send(connectionid,sendvalue,(byte)0,(byte)0);}
    // Prfen ob Senden erfolg hatte
    if (suc<0) statuslabel.setText("Error sending");
    else ftpcounter=ftpcounter+sendsize;
    // Prfen ob gesamte Datei gesendet wurde
    if (ftpcounter>=ftplength) {ftpcounter=0;return 0;}
    else return 11;
}
/*****************************************
* Methode      : ReceiveFtp
* Beschreibung : Kontrolle ob Daten empfangen werden
* Parameter    : keiner
* Rckgabewert : Boolean true wenn Daten empfangen werden
*****************************************/
boolean ReceiveFtp(){
    receivevalue=host.t1.Receive(connectionid,receivesize); // lesen
    if (receivevalue.length>3) {
        ftpreceived=ftpreceived+receivevalue.length-2;
    }
    if (ftpreceived>=ftplength) ftpreceived=0;
    if (receivevalue.length>3) return true; 
    else return false;
}

/*****************************************
* Methode      : ReceiveTelnet
* Beschreibung : Kontrolle ob Daten empfangen werden
* Parameter    : keiner
* Rckgabewert : Boolean true wenn Daten empfangen werden
*****************************************/
boolean ReceiveTelnet(){
    StringBuffer rec = new StringBuffer("");
    receivevalue = host.t1.Receive(connectionid,receivesize); // lesen
    int count=0;
    char valuechar[] = new char[receivevalue.length];  // byte fr Ausgabe vorbereiten
    for (int i=0;i<receivevalue.length;i++) {
         if (receivevalue[i]<32)  receivevalue[i]=32;
         else count=count+1;
         valuechar[i]=(char) receivevalue[i];
    }
    rec. append(valuechar,2,count);
    list1. addItem("Receive");
    rectext=rectext+rec.toString();
    if (receivevalue.length>0) telnet.edit2.setText(rectext); //Empfang ausgeben
    return true;
}

/*****************************************
* Methode: handleEvent
* Beschreibung:reagieren auf ein Event
* Parameter:  Event
* Rckgabewert : ??
*****************************************/
public boolean handleEvent(Event event) {
          if (event.id == Event.ACTION_EVENT && event.target == clientbutton) {
                    clickedclientbutton();
                    return true;
          }
          if (event.id == Event.ACTION_EVENT && event.target == telnetcheck) {
                    clickedtelnetcheck();
                    return true;
          }
          if (event.id == Event.ACTION_EVENT && event.target == ftpcheck) {
                    clickedftpcheck();
                    return true;
          }
          if (event.id == Event.ACTION_EVENT && event.target == serverbutton) {
               clickedserverbutton();
               return true;
          }
          if (event.id == Event.ACTION_EVENT && event.target == abortbutton) {
               clickedabortbutton();
               return true;
          }
          if (event.id == Event.ACTION_EVENT && event.target == dismissbutton) {
               clickeddismissbutton();
               return true;
          }
          return super.handleEvent(event);
}

/*****************************************
* Methode: clickedftpcheck
* Beschreibung: Setzen der Werte fr Ftp
* Parameter:  keine
* Rckgabewert : keine
*****************************************/
public void clickedftpcheck() {
         applicationpanel. remove(telnet);
         applicationpanel. add(ftp);
         // Picture
         setPict(ftppict);
         destport=21;
         locport=21;
         edit1. setText(String.valueOf(locport));
         edit2. setText(String.valueOf(destport));
         resize(450,370);
}

/*****************************************
* Methode: clickedtelnetcheck
* Beschreibung: Setzen der Werte fr Telnet
* Parameter:  keine
* Rckgabewert : keine
*****************************************/
public void clickedtelnetcheck() {
         applicationpanel. remove(ftp);
         applicationpanel. add(telnet);
         // Picture
         setPict(telnetpict);
         destport=23;
         locport=23;
         edit1. setText(String.valueOf(locport));
         edit2. setText(String.valueOf(destport));
         resize(450,370);
 }



/*****************************************
* Methode: clickedserverbutton()
* Beschreibung: Server
* Parameter:  keine
* Rckgabewert : keine
*****************************************/
public void clickedserverbutton() {
         if (connectionid>=0) { //Prfen ob schon Verbindung besteht
            todo=2;             // wenn ja Schlieen der Verbindung
         }
         else {     // wenn Verbindung nicht besteht
            todo=1; // passive open
         }
}
/*****************************************
* Methode: clickedabortbutton()
* Beschreibung: Abort
* Parameter:  keine
* Rckgabewert : keine
*****************************************/
public void clickedabortbutton() {
    todo=20;
}
/*****************************************
* Methode: clickedclientbutton()
* Beschreibung: Client
* Parameter:  keine
* Rckgabewert : keine
*****************************************/
public void clickedclientbutton() {
         if (connectionid>=0) {
            todo=4;
         }
         else todo=3;
}
/*****************************************
* Methode: clickeddismissbutton()
* Beschreibung: Dismiss
* Parameter:  keine
* Rckgabewert : keine
*****************************************/
public void clickeddismissbutton() {
    this .exit();
}
/*****************************************
* Methode: selectedAbout
* Beschreibung: Aboutbox aufrufen
* Parameter:  keine
* Rckgabewert : keine
*****************************************/
public void selectedAbout() {
          if (!about.isShowing()) about.enter();
          else about.exit();
}
/*****************************************
* Methode: Action
* Beschreibung: Aktionen
* Parameter:  Event, arg
* Rckgabewert : ??
*****************************************/
public boolean action(Event event, Object arg) {
     if (event.target instanceof MenuItem) {
          String label = (String) arg;
          if (event.target == kbs) {
               selectedKbs();
               return true;
          } else if (event.target == bs100) {
               selectedBs100();
               return true;
          } else if (event.target == bs20) {
               selectedBs20();
               return true;
          } else if (event.target == bs10) {
               selectedBs10();
               return true;
          } else if (event.target == bs1) {
               selectedBs1();
               return true;
          } else if (event.target == kb1) {
               selectedKb1();
               return true;
          } else if (event.target == b100) {
               selectedB100();
               return true;
          } else if (event.target == b20) {
               selectedB20();
               return true;
          } else if (event.target == b10) {
               selectedB10();
               return true;
          } else if (event.target == b1) {
               selectedB1();
               return true;
          } else if (label.equalsIgnoreCase("Exit!")) {
               selectedExit();
               return true;
          }
     }
     if (event.target == edit1){
            locport=(short) Integer.parseInt(edit1.getText());
     }
     if (event.target == edit2){
            destport=(short) Integer.parseInt(edit2.getText());
     }
     return super.action(event, arg);
}


/*****************************************
* Methode: selectedAbout
* Beschreibung: Aboutbox aufrufen
* Parameter:  keine
* Rckgabewert : keine
*****************************************/

     public void selectedExit() {
          this .exit();
     }
/*****************************************
* Methoden: selected 
* Beschreibung: Festlegen der Gre von Sende und Empfangspuffer und Setzen der Steuerelemente  
* Parameter:  keine
* Rckgabewert : keine
*****************************************/

     public void selectedB1() {
          receivesize=5;
          b10. setState(false);
          b20. setState(false);
          b100. setState(false);
          kb1. setState(false);
     }
     public void selectedB10() {
          receivesize=10;
          b1. setState(false);
          b20. setState(false);
          b100. setState(false);
          kb1. setState(false);
     }
     public void selectedB20() {
          receivesize=20;
          b1. setState(false);
          b10. setState(false);
          b100. setState(false);
          kb1. setState(false);
     }
     public void selectedB100() {
          receivesize=100;
          b1. setState(false);
          b10. setState(false);
          b20. setState(false);
          kb1. setState(false);
     }
     public void selectedKb1() {
          receivesize=1000;
          b1. setState(false);
          b10. setState(false);
          b20. setState(false);
          b100. setState(false);
     }
     public void selectedBs1() {
          sendsize=5;
          bs10. setState(false);
          bs20. setState(false);
          bs100. setState(false);
          kbs. setState(false);
     }
     public void selectedBs10() {
          sendsize=10;
          bs1. setState(false);
          bs20. setState(false);
          bs100. setState(false);
          kbs. setState(false);
     }
     public void selectedBs20() {
          sendsize=20;
          bs1. setState(false);
          bs10. setState(false);
          bs100. setState(false);
          kbs. setState(false);
     }
     public void selectedBs100() {
          sendsize=100;
          bs1. setState(false);
          bs10. setState(false);
          bs20. setState(false);
          kbs. setState(false);
     }
     public void selectedKbs() {
          sendsize=1000;
          bs1. setState(false);
          bs10. setState(false);
          bs20. setState(false);
          bs100. setState(false);
     }
}
